const express = require('express');
const path = require('path');
const app = express();
const PORT = process.env.PORT || 3000;

let tasks = [];
let lastId = 0;


app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(express.static(path.join(__dirname, 'public')));

function validateTaskPayload(payload) {
const errors = [];
if (!payload.title || String(payload.title).trim() === '') {
errors.push('Title is required.');
}
if (!payload.description || String(payload.description).trim() === '') {
errors.push('Description is required.');
}
if (payload.dueDate) {
const iso = /^\d{4}-\d{2}-\d{2}$/;
if (!iso.test(payload.dueDate)) {
errors.push('Due date must be in YYYY-MM-DD format.');
}
}
if (payload.status && !['pending', 'completed'].includes(payload.status)) {
errors.push('Status must be either "pending" or "completed".');
}
return errors;
}


app.get('/tasks', (req, res) => {
res.json({ success: true, data: tasks });
});


app.post('/tasks', (req, res) => {
const { title, description, dueDate, status } = req.body;
const payload = { title, description, dueDate, status: status || 'pending' };
const errors = validateTaskPayload(payload);
if (errors.length) {
return res.status(400).json({ success: false, errors });
}


const newTask = {
id: ++lastId,
title: String(title).trim(),
description: String(description).trim(),
status: payload.status,
dueDate: dueDate || null,
createdAt: new Date().toISOString()
};
});